/*******************************************************
Filename	:  	DW_data_requests_table.sql
Release 	:  	STORET c2.0.4
SIR		:  	1631
Description	:  	Table to record data download requests.
Author		:  	Ganesh Thadkamalla
Date		: 	12/01/2004 
	02/15/2005 - TIR 001.  Removed drop table drop sequence statements. -GT
        06/10/2005 - Added new columns for batch processing. -GT
      09/12/2005 - record_title    varchar2(4000) -GT
      09/14/2005 - added query_text2. -GT
Comments	: 	This script should be run before DW_record_data_request.sql
***********************************************************/
spool DW_data_requests_table.log
show user;

--Create a sequence 
--drop sequence seq_dw_data_request_id;

create sequence seq_dw_data_request_id
start with 1 increment by 1 nomaxvalue nocycle cache 10;

-- We may not want to drop the table.
--drop table dw_data_requests;
create table dw_data_requests
(request_id 		number,
 request_type   	char(3),
 datetime		date,
 filesize_kb		number,
 f_state 		char(1)  default '0',
 f_county		char(1)  default '0',
 f_LatLong		char(1)  default '0',
 f_HUC			char(1)  default '0',
 f_StationType		char(1)  default '0',
 f_Characteristic	char(1)  default '0',
 f_Organization		char(1)  default '0',
 f_station		char(1)  default '0',
 f_act_StartDate	char(1)  default '0',
 f_act_medium 		char(1)  default '0',
 f_project		char(1)  default '0',
 f_act_intent		char(1)  default '0',
 f_Community_sampled	char(1)  default '0',
 request_mode		varchar2(10) default 'ONLINE',
 request_status		varchar2(10) default 'NEW',  --NEW/PROGRESS/FAILED/COMPLETED
 EMAIL_ADDRESS		VARCHAR2(100),
 notified		char(1) default '0', -- 0/1
 query_text		varchar2(4000) ,
 filename		VARCHAR2(30),
 record_count		number,
 record_title    varchar2(4000),
 job_queue_id    number,
 processed_date	date,
 query_text2		varchar2(4000) 
)
tablespace storetdata
storage (initial 2M next 2M pctincrease 0);

alter table dw_data_requests
add constraint pk_dw_data_requests primary key (request_id)
using index
tablespace storetindx
storage (initial 128K next 128K);

create index i_dw_dr_datetime on dw_data_requests(datetime)
tablespace storetindx
storage (initial 512K next 512k pctincrease 0);

spool off;